
<?php $__env->startSection('title', 'Login to Your Account'); ?>
<?php $__env->startSection('content'); ?>

<div class="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-100 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 flex items-center justify-center p-4" x-data="{ mounted: false }" x-init="setTimeout(() => mounted = true, 100)">
    <!-- Background Elements -->
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute top-1/4 left-1/4 w-96 h-96 bg-primary-400/10 rounded-full blur-3xl animate-pulse"></div>
        <div class="absolute bottom-1/4 right-1/4 w-96 h-96 bg-accent-500/10 rounded-full blur-3xl animate-pulse animation-delay-2000"></div>
        <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-gradient-to-r from-primary-400/5 to-accent-500/5 rounded-full blur-3xl"></div>
    </div>

    <!-- Login Container -->
    <div class="relative w-full max-w-md" 
         x-show="mounted" 
         x-transition:enter="transition ease-out duration-700 transform"
         x-transition:enter-start="opacity-0 scale-95 translate-y-4"
         x-transition:enter-end="opacity-100 scale-100 translate-y-0">
        
        <!-- Glowing Border Effect -->
        <div class="absolute inset-0 bg-gradient-to-r from-primary-400/20 to-accent-500/20 rounded-2xl blur-xl"></div>
        
        <!-- Main Card -->
        <div class="relative bg-white/90 dark:bg-gray-800/90 backdrop-blur-xl border border-gray-200/50 dark:border-gray-700/50 rounded-2xl p-8 shadow-2xl">
            
            <!-- Header -->
            <div class="text-center mb-8">
                <!-- Logo with Glow Effect -->
                <div class="mb-6 relative inline-block">
                    <div class="absolute inset-0 bg-primary-400/30 rounded-full blur-lg"></div>
                    <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" 
                         alt="<?php echo e($settings->site_name); ?>" 
                         class="relative h-16 w-16 mx-auto rounded-full border-2 border-white/30 shadow-xl">
                </div>
                
                <!-- Welcome Text -->
                <h1 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">
                    Welcome Back
                </h1>
                <p class="text-gray-600 dark:text-gray-300 text-sm">
                    Sign in to access your celebrity booking account
                </p>
            </div>

            <!-- Status Messages -->
            <?php if(session('status')): ?>
            <div x-data="{ show: true }" 
                 x-show="show" 
                 x-init="setTimeout(() => show = false, 6000)"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform scale-95"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 transform scale-100"
                 x-transition:leave-end="opacity-0 transform scale-95"
                 class="mb-6 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800/30 backdrop-blur-sm rounded-xl p-4">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <i data-lucide="info" class="h-5 w-5 text-blue-600 dark:text-blue-400"></i>
                    </div>
                    <div class="ml-3 flex-1">
                        <p class="text-sm text-blue-800 dark:text-blue-200"><?php echo e(session('status')); ?></p>
                    </div>
                    <button @click="show = false" 
                            class="ml-4 text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-200 transition-colors">
                        <i data-lucide="x" class="h-4 w-4"></i>
                    </button>
                </div>
            </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
            <div x-data="{ show: true }" 
                 x-show="show"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform scale-95"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 class="mb-6 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800/30 backdrop-blur-sm rounded-xl p-4">
                <div class="flex items-start">
                    <div class="flex-shrink-0">
                        <i data-lucide="alert-circle" class="h-5 w-5 text-red-600 dark:text-red-400 mt-0.5"></i>
                    </div>
                    <div class="ml-3 flex-1">
                        <h3 class="text-sm font-medium text-red-800 dark:text-red-200 mb-2">Authentication Error</h3>
                        <ul class="text-sm text-red-700 dark:text-red-300 space-y-1">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="flex items-center">
                                <i data-lucide="chevron-right" class="h-3 w-3 mr-1"></i>
                                <?php echo e($error); ?>

                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <button @click="show = false" 
                            class="ml-4 text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-200 transition-colors">
                        <i data-lucide="x" class="h-4 w-4"></i>
                    </button>
                </div>
            </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form class="space-y-6" action="<?php echo e(route('login')); ?>" method="POST" 
                  x-data="{ isSubmitting: false }" 
                  @submit="console.log('Form submitting...'); isSubmitting = true">
                <?php echo csrf_field(); ?>
                
                <!-- Email Field -->
                <div class="space-y-2">
                    <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Email Address
                    </label>
                    <div class="relative group">
                        <div class="absolute inset-0 bg-gradient-to-r from-blue-500/10 to-blue-600/10 rounded-xl blur-sm group-focus-within:blur-md transition-all duration-300"></div>
                        <div class="relative flex items-center">
                            <div class="absolute left-4 flex items-center pointer-events-none">
                                <i data-lucide="mail" class="h-5 w-5 text-gray-400 dark:text-gray-500 group-focus-within:text-blue-600 dark:group-focus-within:text-blue-400 transition-colors"></i>
                            </div>
                            <input id="email" 
                                   name="email" 
                                   type="email" 
                                   autocomplete="email" 
                                   required 
                                   value="<?php echo e(old('email')); ?>" 
                                   class="relative w-full pl-12 pr-4 py-4 bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 rounded-xl text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 dark:focus:ring-blue-400 focus:border-blue-500 dark:focus:border-blue-400 backdrop-blur-sm transition-all duration-300" 
                                   placeholder="Enter your email">
                        </div>
                    </div>
                </div>

                <!-- Password Field -->
                <div class="space-y-2" x-data="{ showPassword: false }">
                    <label for="password" class="block text-sm font-medium text-gray-700 dark:text-gray-300">
                        Password
                    </label>
                    <div class="relative group">
                        <div class="absolute inset-0 bg-gradient-to-r from-blue-500/10 to-blue-600/10 rounded-xl blur-sm group-focus-within:blur-md transition-all duration-300"></div>
                        <div class="relative flex items-center">
                            <div class="absolute left-4 flex items-center pointer-events-none">
                                <i data-lucide="lock" class="h-5 w-5 text-gray-400 dark:text-gray-500 group-focus-within:text-blue-600 dark:group-focus-within:text-blue-400 transition-colors"></i>
                            </div>
                            <input :type="showPassword ? 'text' : 'password'" 
                                   id="password" 
                                   name="password" 
                                   required 
                                   class="relative w-full pl-12 pr-12 py-4 bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 rounded-xl text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 dark:focus:ring-blue-400 focus:border-blue-500 dark:focus:border-blue-400 backdrop-blur-sm transition-all duration-300" 
                                   placeholder="Enter your password">
                            <button type="button" 
                                    @click="showPassword = !showPassword" 
                                    class="absolute right-4 text-gray-400 dark:text-gray-500 hover:text-gray-600 dark:hover:text-gray-300 transition-colors focus:outline-none">
                                <i data-lucide="eye" x-show="!showPassword" class="h-5 w-5"></i>
                                <i data-lucide="eye-off" x-show="showPassword" class="h-5 w-5"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Remember Me & Forgot Password -->
                <div class="flex items-center justify-between">
                    <label class="flex items-center group cursor-pointer">
                        <input type="checkbox" 
                               id="remember" 
                               name="remember" 
                               class="w-4 h-4 text-blue-600 bg-gray-100 dark:bg-gray-600 border-gray-300 dark:border-gray-500 rounded focus:ring-blue-500 dark:focus:ring-blue-400 focus:ring-2">
                        <span class="ml-2 text-sm text-gray-600 dark:text-gray-300 group-hover:text-gray-800 dark:group-hover:text-gray-100 transition-colors">
                            Remember me
                        </span>
                    </label>
                    
                    <a href="<?php echo e(route('password.request')); ?>" 
                       class="text-sm font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                        Forgot password?
                    </a>
                </div>

                <!-- Sign In Button -->
                <button type="submit" 
                        :disabled="isSubmitting"
                        class="relative w-full group overflow-hidden">
                    <!-- Button Glow Effect -->
                    <div class="absolute inset-0 bg-gradient-to-r from-blue-600 to-blue-700 rounded-xl blur-sm group-hover:blur-md transition-all duration-300"></div>
                    
                    <!-- Button Content -->
                    <div class="relative bg-gradient-to-r from-blue-600 to-blue-700 text-white font-semibold py-4 px-6 rounded-xl flex items-center justify-center space-x-2 transform group-hover:scale-[1.02] group-active:scale-[0.98] transition-all duration-200">
                        <i data-lucide="log-in" class="h-5 w-5" x-show="!isSubmitting"></i>
                        <div x-show="isSubmitting" class="w-5 h-5 border-2 border-white/30 border-t-white rounded-full animate-spin"></div>
                        <span x-text="isSubmitting ? 'Signing In...' : 'Sign In'"></span>
                    </div>
                </button>

                <!-- Social Login -->
                <?php if($settings->enable_social_login == 'yes'): ?>
                <div class="relative my-8">
                    <div class="absolute inset-0 flex items-center">
                        <div class="w-full border-t border-white/20"></div>
                    </div>
                    <div class="relative flex justify-center text-sm">
                        <span class="px-4 bg-white dark:bg-gray-800 text-gray-500 dark:text-gray-400">
                            Or continue with
                        </span>
                    </div>
                </div>

                <a href="<?php echo e(route('social.redirect', ['social' => 'google'])); ?>" 
                   class="relative w-full group">
                    <div class="absolute inset-0 bg-gray-50 dark:bg-gray-700/50 rounded-xl blur-sm group-hover:blur-md transition-all duration-300"></div>
                    <div class="relative bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 text-gray-900 dark:text-white py-3 px-4 rounded-xl flex items-center justify-center space-x-3 hover:bg-gray-100 dark:hover:bg-gray-600/50 transition-all duration-300 backdrop-blur-sm">
                        <svg class="h-5 w-5" viewBox="0 0 24 24">
                            <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                            <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                            <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                            <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                        </svg>
                        <span class="font-medium">Continue with Google</span>
                    </div>
                </a>
                <?php endif; ?>
            </form>

            <!-- Debug Script -->
            <script>
            document.addEventListener('DOMContentLoaded', function() {
                const form = document.querySelector('form[action="/login"]');
                const submitButton = document.querySelector('button[type="submit"]');
                
                console.log('Debug script loaded');
                console.log('Form found:', !!form);
                console.log('Submit button found:', !!submitButton);
                
                if (form) {
                    console.log('Form action:', form.action);
                    console.log('Form method:', form.method);
                    
                    form.addEventListener('submit', function(e) {
                        console.log('Form submit event triggered');
                        console.log('Event default prevented:', e.defaultPrevented);
                        
                        // Check all form data
                        const formData = new FormData(form);
                        console.log('Form fields:');
                        for (let [key, value] of formData.entries()) {
                            console.log(`  ${key}: ${value}`);
                        }
                    });
                }
                
                if (submitButton) {
                    submitButton.addEventListener('click', function(e) {
                        console.log('Submit button clicked');
                        console.log('Button disabled:', this.disabled);
                        console.log('Event default prevented:', e.defaultPrevented);
                    });
                }
            });
            </script>

            <!-- Register Link -->
            <div class="mt-8 text-center">
                <p class="text-gray-600 dark:text-gray-300 text-sm">
                    Don't have an account? 
                    <a href="<?php echo e(route('register')); ?>" 
                       class="font-medium text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                        Sign up now
                    </a>
                </p>
                <p class="text-gray-500 dark:text-gray-400 text-xs mt-2">
                    By signing in, you agree to our 
                    <a href="<?php echo e(route('privacy')); ?>" class="text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                        Terms & Conditions
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        lucide.createIcons();
    });
</script>

<style>
    @keyframes  float {
        0%, 100% { transform: translateY(0px) rotate(0deg); }
        33% { transform: translateY(-10px) rotate(1deg); }
        66% { transform: translateY(5px) rotate(-1deg); }
    }
    
    .animation-delay-2000 {
        animation-delay: 2s;
    }
    
    /* Custom scrollbar for better aesthetics */
    ::-webkit-scrollbar {
        width: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: rgba(255, 255, 255, 0.1);
        border-radius: 4px;
    }
    
    ::-webkit-scrollbar-thumb {
        background: rgba(255, 255, 255, 0.3);
        border-radius: 4px;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: rgba(255, 255, 255, 0.5);
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\celeb\resources\views/auth/modern_login.blade.php ENDPATH**/ ?>