<?php $__env->startSection('title', 'Manage Celebrity Bookings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-calendar-check text-primary"></i> Celebrity Bookings Management
            </h1>
            <p class="mb-0 text-gray-600">Manage and track all celebrity booking requests</p>
        </div>
        <div class="d-flex gap-2">
            <a href="#" class="btn btn-outline-primary btn-sm" data-toggle="modal" data-target="#bulkActionModal">
                <i class="fas fa-tasks"></i> Bulk Actions
            </a>
            <a href="#" class="btn btn-success btn-sm" onclick="window.print()">
                <i class="fas fa-print"></i> Print Report
            </a>
        </div>
    </div>

    <!-- Status Messages -->
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
        <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
        <i class="fas fa-exclamation-triangle"></i> <?php echo e(session('error')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending Bookings</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($bookings->where('booking_status', 'pending')->count()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Approved Bookings</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($bookings->where('booking_status', 'approved')->count()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Completed Bookings</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($bookings->where('booking_status', 'completed')->count()); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-trophy fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Revenue</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                $<?php echo e(number_format($bookings->where('payment_status', 'paid')->sum('total_amount'), 2)); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Filters -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-filter"></i> Advanced Filters & Search
            </h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Quick Actions:</div>
                    <a class="dropdown-item" href="<?php echo e(route('admin.bookings.index')); ?>?status=pending">
                        <i class="fas fa-clock fa-sm fa-fw mr-2 text-gray-400"></i> View Pending
                    </a>
                    <a class="dropdown-item" href="<?php echo e(route('admin.bookings.index')); ?>?status=approved">
                        <i class="fas fa-check fa-sm fa-fw mr-2 text-gray-400"></i> View Approved
                    </a>
                    <div class="dropdown-divider"></div>
                    <div class="dropdown-header">Export Options:</div>
                    <a class="dropdown-item" href="#" onclick="exportData('csv')">
                        <i class="fas fa-file-csv fa-sm fa-fw mr-2 text-gray-400"></i> Export CSV
                    </a>
                    <a class="dropdown-item" href="#" onclick="exportData('excel')">
                        <i class="fas fa-file-excel fa-sm fa-fw mr-2 text-gray-400"></i> Export Excel
                    </a>
                    <a class="dropdown-item" href="#" onclick="exportData('pdf')">
                        <i class="fas fa-file-pdf fa-sm fa-fw mr-2 text-gray-400"></i> Export PDF
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.bookings.index')); ?>" class="needs-validation" novalidate>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="status" class="form-label font-weight-bold">
                            <i class="fas fa-flag"></i> Booking Status
                        </label>
                        <select class="form-control" id="status" name="status">
                            <option value="">All Statuses</option>
                            <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>
                                <i class="fas fa-clock"></i> Pending
                            </option>
                            <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>
                                <i class="fas fa-check-circle"></i> Approved
                            </option>
                            <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>
                                <i class="fas fa-trophy"></i> Completed
                            </option>
                            <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>
                                <i class="fas fa-times-circle"></i> Cancelled
                            </option>
                            <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>
                                <i class="fas fa-ban"></i> Rejected
                            </option>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="payment_status" class="form-label font-weight-bold">
                            <i class="fas fa-credit-card"></i> Payment Status
                        </label>
                        <select class="form-control" id="payment_status" name="payment_status">
                            <option value="">All Payment Status</option>
                            <option value="pending" <?php echo e(request('payment_status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="paid" <?php echo e(request('payment_status') == 'paid' ? 'selected' : ''); ?>>Paid</option>
                            <option value="refunded" <?php echo e(request('payment_status') == 'refunded' ? 'selected' : ''); ?>>Refunded</option>
                            <option value="cancelled" <?php echo e(request('payment_status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="celebrity" class="form-label font-weight-bold">
                            <i class="fas fa-star"></i> Celebrity
                        </label>
                        <select class="form-control select2" id="celebrity" name="celebrity_id">
                            <option value="">All Celebrities</option>
                            <?php $__currentLoopData = $celebrities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $celebrity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($celebrity->id); ?>" <?php echo e(request('celebrity_id') == $celebrity->id ? 'selected' : ''); ?>>
                                    <?php echo e($celebrity->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="booking_type" class="form-label font-weight-bold">
                            <i class="fas fa-tag"></i> Booking Type
                        </label>
                        <select class="form-control" id="booking_type" name="booking_type">
                            <option value="">All Types</option>
                            <option value="booking" <?php echo e(request('booking_type') == 'booking' ? 'selected' : ''); ?>>Standard Booking</option>
                            <option value="donation" <?php echo e(request('booking_type') == 'donation' ? 'selected' : ''); ?>>Donation</option>
                            <option value="fan_card" <?php echo e(request('booking_type') == 'fan_card' ? 'selected' : ''); ?>>Fan Card</option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="date_from" class="form-label font-weight-bold">
                            <i class="fas fa-calendar-alt"></i> Event Date From
                        </label>
                        <input type="date" class="form-control" id="date_from" name="date_from" value="<?php echo e(request('date_from')); ?>">
                    </div>

                    <div class="col-md-3 mb-3">
                        <label for="date_to" class="form-label font-weight-bold">
                            <i class="fas fa-calendar-alt"></i> Event Date To
                        </label>
                        <input type="date" class="form-control" id="date_to" name="date_to" value="<?php echo e(request('date_to')); ?>">
                    </div>

                    <div class="col-md-4 mb-3">
                        <label for="search" class="form-label font-weight-bold">
                            <i class="fas fa-search"></i> Search
                        </label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="search" name="search"
                                   placeholder="Search by reference, name, email..." value="<?php echo e(request('search')); ?>">
                            <div class="input-group-append">
                                <span class="input-group-text"><i class="fas fa-search"></i></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label for="per_page" class="form-label font-weight-bold">
                            <i class="fas fa-list"></i> Per Page
                        </label>
                        <select class="form-control" id="per_page" name="per_page">
                            <option value="10" <?php echo e(request('per_page', 10) == 10 ? 'selected' : ''); ?>>10</option>
                            <option value="25" <?php echo e(request('per_page') == 25 ? 'selected' : ''); ?>>25</option>
                            <option value="50" <?php echo e(request('per_page') == 50 ? 'selected' : ''); ?>>50</option>
                            <option value="100" <?php echo e(request('per_page') == 100 ? 'selected' : ''); ?>>100</option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="sort" class="form-label font-weight-bold">
                            <i class="fas fa-sort"></i> Sort By
                        </label>
                        <div class="row">
                            <div class="col-8">
                                <select class="form-control" id="sort" name="sort">
                                    <option value="created_at" <?php echo e(request('sort', 'created_at') == 'created_at' ? 'selected' : ''); ?>>Date Created</option>
                                    <option value="event_date" <?php echo e(request('sort') == 'event_date' ? 'selected' : ''); ?>>Event Date</option>
                                    <option value="booking_fee" <?php echo e(request('sort') == 'booking_fee' ? 'selected' : ''); ?>>Booking Fee</option>
                                    <option value="total_amount" <?php echo e(request('sort') == 'total_amount' ? 'selected' : ''); ?>>Total Amount</option>
                                    <option value="booking_status" <?php echo e(request('sort') == 'booking_status' ? 'selected' : ''); ?>>Status</option>
                                </select>
                            </div>
                            <div class="col-4">
                                <select class="form-control" id="direction" name="direction">
                                    <option value="desc" <?php echo e(request('direction', 'desc') == 'desc' ? 'selected' : ''); ?>>Descending</option>
                                    <option value="asc" <?php echo e(request('direction') == 'asc' ? 'selected' : ''); ?>>Ascending</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 mb-3 d-flex align-items-end">
                        <div class="btn-group w-100" role="group">
                            <button class="btn btn-primary" type="submit">
                                <i class="fas fa-filter"></i> Apply Filters
                            </button>
                            <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-undo"></i> Reset
                            </a>
                            <button class="btn btn-info" type="button" onclick="toggleAdvancedFilters()">
                                <i class="fas fa-cog"></i> Advanced
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Enhanced Bookings Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-table"></i> All Celebrity Bookings
                <span class="badge badge-secondary"><?php echo e($bookings->total()); ?> Total</span>
            </h6>
            <div class="d-flex">
                <div class="form-check mr-3">
                    <input class="form-check-input" type="checkbox" id="selectAll">
                    <label class="form-check-label" for="selectAll">
                        Select All
                    </label>
                </div>
                <button class="btn btn-sm btn-outline-primary" onclick="refreshTable()">
                    <i class="fas fa-sync"></i> Refresh
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover" id="bookingsTable" width="100%" cellspacing="0">
                    <thead class="thead-light">
                        <tr>
                            <th width="3%">
                                <input type="checkbox" id="selectAllHeader" onchange="toggleSelectAll()">
                            </th>
                            <th width="8%">
                                <i class="fas fa-hashtag"></i> Reference
                            </th>
                            <th width="10%">
                                <i class="fas fa-tag"></i> Type
                            </th>
                            <th width="15%">
                                <i class="fas fa-star"></i> Celebrity
                            </th>
                            <th width="15%">
                                <i class="fas fa-user"></i> Customer
                            </th>
                            <th width="12%">
                                <i class="fas fa-calendar"></i> Event Date
                            </th>
                            <th width="10%">
                                <i class="fas fa-clipboard-list"></i> Event Type
                            </th>
                            <th width="8%">
                                <i class="fas fa-dollar-sign"></i> Amount
                            </th>
                            <th width="8%">
                                <i class="fas fa-flag"></i> Status
                            </th>
                            <th width="8%">
                                <i class="fas fa-credit-card"></i> Payment
                            </th>
                            <th width="12%">
                                <i class="fas fa-cogs"></i> Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="booking-row" data-booking-id="<?php echo e($booking->id); ?>"
                            data-status="<?php echo e($booking->booking_status); ?>"
                            onclick="highlightRow(this)">
                            <td>
                                <input type="checkbox" class="booking-checkbox" value="<?php echo e($booking->id); ?>"
                                       onclick="event.stopPropagation()">
                            </td>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="font-weight-bold text-primary"><?php echo e($booking->booking_reference); ?></span>
                                    <small class="text-muted"><?php echo e($booking->created_at->format('M j, Y')); ?></small>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo e($booking->booking_type == 'booking' ? 'primary' :
                                    ($booking->booking_type == 'donation' ? 'success' : 'warning')); ?> badge-pill">
                                    <?php if($booking->booking_type == 'booking'): ?>
                                        <i class="fas fa-calendar-check"></i> Booking
                                    <?php elseif($booking->booking_type == 'donation'): ?>
                                        <i class="fas fa-heart"></i> Donation
                                    <?php else: ?>
                                        <i class="fas fa-id-card"></i> Fan Card
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <?php if($booking->celebrity && $booking->celebrity->photo): ?>
                                        <img src="<?php echo e(asset('storage/' . $booking->celebrity->photo)); ?>"
                                             alt="<?php echo e($booking->celebrity->name); ?>"
                                             class="img-profile rounded-circle mr-2"
                                             style="width: 35px; height: 35px; object-fit: cover;">
                                    <?php else: ?>
                                        <div class="bg-primary rounded-circle mr-2 d-flex align-items-center justify-content-center"
                                             style="width: 35px; height: 35px;">
                                            <i class="fas fa-user text-white"></i>
                                        </div>
                                    <?php endif; ?>
                                    <div>
                                        <div class="font-weight-bold"><?php echo e($booking->celebrity->name ?? 'N/A'); ?></div>
                                        <small class="text-muted"><?php echo e($booking->celebrity->known_for ?? ''); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="font-weight-bold"><?php echo e($booking->full_name); ?></span>
                                    <small class="text-muted">
                                        <i class="fas fa-envelope"></i> <?php echo e($booking->email); ?>

                                    </small>
                                    <small class="text-muted">
                                        <i class="fas fa-phone"></i> <?php echo e($booking->phone); ?>

                                    </small>
                                    <?php if($booking->user_id): ?>
                                        <small class="text-info">
                                            <i class="fas fa-user-check"></i> Registered User
                                        </small>
                                    <?php else: ?>
                                        <small class="text-warning">
                                            <i class="fas fa-user-times"></i> Guest Booking
                                        </small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="font-weight-bold">
                                        <i class="fas fa-calendar-day"></i> <?php echo e($booking->event_date->format('M j, Y')); ?>

                                    </span>
                                    <small class="text-muted">
                                        <i class="fas fa-clock"></i> <?php echo e(\Carbon\Carbon::parse($booking->event_time)->format('g:i A')); ?>

                                    </small>
                                    <?php if($booking->duration > 0): ?>
                                        <small class="text-muted">
                                            <i class="fas fa-hourglass-half"></i> <?php echo e($booking->duration); ?> mins
                                        </small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="font-weight-bold"><?php echo e($booking->event_type); ?></span>
                                    <?php if($booking->event_location): ?>
                                        <small class="text-muted">
                                            <i class="fas fa-map-marker-alt"></i> <?php echo e(Str::limit($booking->event_location, 20)); ?>

                                        </small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="font-weight-bold text-success">
                                        $<?php echo e(number_format($booking->total_amount, 2)); ?>

                                    </span>
                                    <?php if($booking->booking_fee > 0): ?>
                                        <small class="text-muted">
                                            Fee: $<?php echo e(number_format($booking->booking_fee, 2)); ?>

                                        </small>
                                    <?php endif; ?>
                                    <?php if($booking->service_fee > 0): ?>
                                        <small class="text-muted">
                                            Service: $<?php echo e(number_format($booking->service_fee, 2)); ?>

                                        </small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo e($booking->booking_status == 'pending' ? 'warning' :
                                    ($booking->booking_status == 'approved' ? 'primary' :
                                    ($booking->booking_status == 'completed' ? 'success' :
                                    ($booking->booking_status == 'cancelled' ? 'danger' : 'secondary')))); ?> badge-pill">
                                    <?php switch($booking->booking_status):
                                        case ('pending'): ?>
                                            <i class="fas fa-clock"></i> Pending
                                            <?php break; ?>
                                        <?php case ('approved'): ?>
                                            <i class="fas fa-check-circle"></i> Approved
                                            <?php break; ?>
                                        <?php case ('completed'): ?>
                                            <i class="fas fa-trophy"></i> Completed
                                            <?php break; ?>
                                        <?php case ('cancelled'): ?>
                                            <i class="fas fa-times-circle"></i> Cancelled
                                            <?php break; ?>
                                        <?php case ('rejected'): ?>
                                            <i class="fas fa-ban"></i> Rejected
                                            <?php break; ?>
                                        <?php default: ?>
                                            <?php echo e(ucfirst($booking->booking_status)); ?>

                                    <?php endswitch; ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo e($booking->payment_status == 'pending' ? 'warning' :
                                    ($booking->payment_status == 'paid' ? 'success' :
                                    ($booking->payment_status == 'refunded' ? 'info' : 'danger'))); ?> badge-pill">
                                    <?php switch($booking->payment_status):
                                        case ('pending'): ?>
                                            <i class="fas fa-hourglass-half"></i> Pending
                                            <?php break; ?>
                                        <?php case ('paid'): ?>
                                            <i class="fas fa-check-double"></i> Paid
                                            <?php break; ?>
                                        <?php case ('refunded'): ?>
                                            <i class="fas fa-undo"></i> Refunded
                                            <?php break; ?>
                                        <?php case ('cancelled'): ?>
                                            <i class="fas fa-times"></i> Cancelled
                                            <?php break; ?>
                                        <?php default: ?>
                                            <?php echo e(ucfirst($booking->payment_status)); ?>

                                    <?php endswitch; ?>
                                </span>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <!-- View Button -->
                                    <a href="<?php echo e(route('admin.bookings.show', $booking->id)); ?>"
                                       class="btn btn-sm btn-outline-info"
                                       title="View Details"
                                       data-toggle="tooltip">
                                        <i class="fas fa-eye"></i>
                                    </a>

                                    <!-- Edit Button -->
                                    <a href="<?php echo e(route('admin.bookings.edit', $booking->id)); ?>"
                                       class="btn btn-sm btn-outline-primary"
                                       title="Edit Booking"
                                       data-toggle="tooltip">
                                        <i class="fas fa-edit"></i>
                                    </a>

                                    <!-- Quick Actions Dropdown -->
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                                title="Quick Actions" data-toggle="tooltip">
                                            <i class="fas fa-cog"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right">
                                            <?php if($booking->booking_status == 'pending'): ?>
                                                <a class="dropdown-item text-success" href="#"
                                                   onclick="quickStatusUpdate(<?php echo e($booking->id); ?>, 'approved')">
                                                    <i class="fas fa-check fa-sm fa-fw mr-2"></i> Quick Approve
                                                </a>
                                                <a class="dropdown-item text-danger" href="#"
                                                   onclick="quickStatusUpdate(<?php echo e($booking->id); ?>, 'rejected')">
                                                    <i class="fas fa-times fa-sm fa-fw mr-2"></i> Quick Reject
                                                </a>
                                                <div class="dropdown-divider"></div>
                                            <?php endif; ?>

                                            <?php if($booking->booking_status == 'approved'): ?>
                                                <a class="dropdown-item text-success" href="#"
                                                   onclick="quickStatusUpdate(<?php echo e($booking->id); ?>, 'completed')">
                                                    <i class="fas fa-check-double fa-sm fa-fw mr-2"></i> Mark Complete
                                                </a>
                                            <?php endif; ?>

                                            <?php if($booking->booking_status != 'cancelled' && $booking->booking_status != 'completed'): ?>
                                                <a class="dropdown-item text-warning" href="#"
                                                   onclick="quickStatusUpdate(<?php echo e($booking->id); ?>, 'cancelled')">
                                                    <i class="fas fa-ban fa-sm fa-fw mr-2"></i> Cancel
                                                </a>
                                            <?php endif; ?>

                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item" href="#" onclick="sendEmail(<?php echo e($booking->id); ?>)">
                                                <i class="fas fa-envelope fa-sm fa-fw mr-2"></i> Email Customer
                                            </a>
                                            <a class="dropdown-item" href="#" onclick="addNote(<?php echo e($booking->id); ?>)">
                                                <i class="fas fa-sticky-note fa-sm fa-fw mr-2"></i> Add Note
                                            </a>

                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item text-danger" href="#"
                                               onclick="confirmDelete(<?php echo e($booking->id); ?>, '<?php echo e($booking->booking_reference); ?>')">
                                                <i class="fas fa-trash fa-sm fa-fw mr-2"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="11" class="text-center py-4">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-inbox fa-3x text-gray-300 mb-3"></i>
                                    <h5 class="text-gray-500">No bookings found</h5>
                                    <p class="text-gray-400">Try adjusting your filters or search criteria</p>
                                    <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-outline-primary">
                                        <i class="fas fa-refresh"></i> Clear Filters
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Enhanced Pagination -->
            <?php if($bookings->hasPages()): ?>
            <div class="d-flex justify-content-between align-items-center mt-4">
                <div class="showing-info">
                    <span class="text-muted">
                        Showing <?php echo e($bookings->firstItem()); ?> to <?php echo e($bookings->lastItem()); ?> of <?php echo e($bookings->total()); ?> results
                    </span>
                </div>
                <div class="pagination-wrapper">
                    <?php echo e($bookings->appends(request()->query())->links()); ?>

                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<!-- Bulk Action Modal -->
<div class="modal fade" id="bulkActionModal" tabindex="-1" role="dialog" aria-labelledby="bulkActionModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="bulkActionModalLabel">Bulk Actions</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="bulkActionForm">
                    <div class="form-group">
                        <label for="bulkAction">Select Action</label>
                        <select class="form-control" id="bulkAction" name="action" required>
                            <option value="">Choose an action...</option>
                            <option value="approve">Approve Selected Bookings</option>
                            <option value="reject">Reject Selected Bookings</option>
                            <option value="cancel">Cancel Selected Bookings</option>
                            <option value="delete">Delete Selected Bookings</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="bulkNotes">Notes (Optional)</label>
                        <textarea class="form-control" id="bulkNotes" name="notes" rows="3" placeholder="Add notes for this bulk action..."></textarea>
                    </div>
                    <div class="selected-count">
                        <span class="badge badge-info">0 bookings selected</span>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="executeBulkAction()">Execute Action</button>
            </div>
        </div>
    </div>
</div>

<!-- Quick Status Update Modal -->
<div class="modal fade" id="quickStatusModal" tabindex="-1" role="dialog" aria-labelledby="quickStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="quickStatusModalLabel">Update Booking Status</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="quickStatusForm">
                    <input type="hidden" id="quickBookingId" name="booking_id">
                    <input type="hidden" id="quickStatus" name="status">
                    <div class="form-group">
                        <label for="quickNotes">Notes</label>
                        <textarea class="form-control" id="quickNotes" name="admin_notes" rows="3" placeholder="Add notes for this status update..."></textarea>
                    </div>
                </form>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    <span id="quickStatusMessage"></span>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="executeQuickStatus()">Update Status</button>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1" role="dialog" aria-labelledby="deleteConfirmModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteConfirmModalLabel">Confirm Delete</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>Warning!</strong> This action cannot be undone.
                </div>
                <p>Are you sure you want to permanently delete booking <strong id="deleteBookingRef"></strong>?</p>
                <p class="text-muted">This will remove all associated records and cannot be recovered.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete Permanently</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        placeholder: 'All Celebrities',
        width: '100%'
    });

    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();

    // Auto-refresh every 30 seconds
    setInterval(function() {
        updateBookingCounts();
    }, 30000);
});

// Toggle select all checkboxes
function toggleSelectAll() {
    const selectAllHeader = document.getElementById('selectAllHeader');
    const checkboxes = document.querySelectorAll('.booking-checkbox');

    checkboxes.forEach(checkbox => {
        checkbox.checked = selectAllHeader.checked;
    });

    updateSelectedCount();
}

// Update selected count
function updateSelectedCount() {
    const selectedCount = document.querySelectorAll('.booking-checkbox:checked').length;
    document.querySelector('.selected-count .badge').textContent = `${selectedCount} bookings selected`;
}

// Highlight table row on click
function highlightRow(row) {
    // Remove previous highlights
    document.querySelectorAll('.booking-row').forEach(r => r.classList.remove('table-active'));
    // Add highlight to clicked row
    row.classList.add('table-active');
}

// Quick status update
function quickStatusUpdate(bookingId, status) {
    document.getElementById('quickBookingId').value = bookingId;
    document.getElementById('quickStatus').value = status;

    const messages = {
        'approved': 'This will approve the booking and notify the customer.',
        'rejected': 'This will reject the booking and notify the customer.',
        'completed': 'This will mark the booking as completed.',
        'cancelled': 'This will cancel the booking and notify the customer.'
    };

    document.getElementById('quickStatusMessage').textContent = messages[status];
    $('#quickStatusModal').modal('show');
}

// Execute quick status update
function executeQuickStatus() {
    const form = document.getElementById('quickStatusForm');
    const formData = new FormData(form);
    const bookingId = formData.get('booking_id');

    // Create and submit form
    const submitForm = document.createElement('form');
    submitForm.method = 'POST';
    submitForm.action = `/admin/dashboard/bookings/${bookingId}/status`;

    // Add CSRF token
    const csrfToken = document.createElement('input');
    csrfToken.type = 'hidden';
    csrfToken.name = '_token';
    csrfToken.value = '<?php echo e(csrf_token()); ?>';
    submitForm.appendChild(csrfToken);

    // Add method
    const methodInput = document.createElement('input');
    methodInput.type = 'hidden';
    methodInput.name = '_method';
    methodInput.value = 'PUT';
    submitForm.appendChild(methodInput);

    // Add booking status
    const statusInput = document.createElement('input');
    statusInput.type = 'hidden';
    statusInput.name = 'booking_status';
    statusInput.value = formData.get('status');
    submitForm.appendChild(statusInput);

    // Add admin notes
    const notesInput = document.createElement('input');
    notesInput.type = 'hidden';
    notesInput.name = 'admin_notes';
    notesInput.value = formData.get('admin_notes');
    submitForm.appendChild(notesInput);

    document.body.appendChild(submitForm);
    submitForm.submit();
}

// Confirm delete
function confirmDelete(bookingId, bookingRef) {
    document.getElementById('deleteBookingRef').textContent = bookingRef;
    document.getElementById('confirmDeleteBtn').onclick = function() {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/dashboard/bookings/${bookingId}`;

        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '<?php echo e(csrf_token()); ?>';
        form.appendChild(csrfToken);

        const methodInput = document.createElement('input');
        methodInput.type = 'hidden';
        methodInput.name = '_method';
        methodInput.value = 'DELETE';
        form.appendChild(methodInput);

        document.body.appendChild(form);
        form.submit();
    };

    $('#deleteConfirmModal').modal('show');
}

// Send email to customer
function sendEmail(bookingId) {
    // Implement email functionality
    alert('Email functionality will be implemented');
}

// Add note to booking
function addNote(bookingId) {
    // Implement add note functionality
    alert('Add note functionality will be implemented');
}

// Execute bulk action
function executeBulkAction() {
    const selectedCheckboxes = document.querySelectorAll('.booking-checkbox:checked');
    const action = document.getElementById('bulkAction').value;

    if (selectedCheckboxes.length === 0) {
        alert('Please select at least one booking');
        return;
    }

    if (!action) {
        alert('Please select an action');
        return;
    }

    // Implement bulk action logic
    alert(`Bulk action "${action}" will be implemented for ${selectedCheckboxes.length} bookings`);
}

// Refresh table
function refreshTable() {
    location.reload();
}

// Export data
function exportData(format) {
    const currentUrl = new URL(window.location);
    currentUrl.searchParams.set('export', format);
    window.open(currentUrl.href, '_blank');
}

// Update booking counts (for real-time updates)
function updateBookingCounts() {
    // Implement AJAX call to update counts
    console.log('Updating booking counts...');
}

// Advanced filters toggle
function toggleAdvancedFilters() {
    // Implement advanced filters toggle
    console.log('Advanced filters toggled');
}

// Listen for checkbox changes
document.addEventListener('change', function(e) {
    if (e.target.classList.contains('booking-checkbox')) {
        updateSelectedCount();
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\celeb\resources\views/admin/bookings/index.blade.php ENDPATH**/ ?>