<?php

use App\Http\Controllers\Admin\ClearCacheController;
use Illuminate\Support\Facades\Route;
use App\Models\Settings;
use Laravel\Fortify\Http\Controllers\NewPasswordController;
use App\Http\Controllers\AutoTaskController;
use App\Http\Controllers\HomePageController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

require __DIR__ . '/admin/web.php';
require __DIR__ . '/user/web.php';
require __DIR__ . '/botman.php';

// Authentication routes
Route::get('/login', function () {
    return view('auth.modern_login');
})->name('login')->middleware('guest');

Route::get('/register', function () {
    return view('auth.modern_register');
})->name('register')->middleware('guest');



//cron url
Route::get('/cron', [AutoTaskController::class, 'autotopup'])->name('cron');
//Front Pages Route
Route::get('/', [HomePageController::class, 'index'])->name('home');
Route::get('book_celebrity', [HomePageController::class, 'book'])->name('book');
Route::get('book_celebrity_now/{id}', [App\Http\Controllers\BookingController::class, 'showBookingForm'])->name('book_celebrity_now');
Route::get('membership_card/{id}', [HomePageController::class, 'membership_card'])->name('membership_card');
Route::get('donate/{id}', [HomePageController::class, 'donate'])->name('donate');

// Original booking route
Route::post('bookingstore', [HomePageController::class, 'bookingstore'])->name('bookingstore');

// New modern booking system routes
Route::get('celebrity/book/{id}', [App\Http\Controllers\BookingController::class, 'showBookingForm'])->name('booking.form');
Route::post('celebrity/booking/process', [App\Http\Controllers\BookingController::class, 'processBooking'])->name('processBooking');
Route::get('celebrity/booking/deposit/{reference}', [App\Http\Controllers\BookingController::class, 'showDepositPage'])->name('booking.deposit');
Route::post('celebrity/booking/payment', [App\Http\Controllers\BookingController::class, 'processPayment'])->name('processPayment');
Route::get('celebrity/booking/receipt/{reference}', [App\Http\Controllers\BookingController::class, 'showReceiptPage'])->name('booking.receipt');

// Modern Dashboard route
Route::get('user/dashboard', [App\Http\Controllers\User\DashboardController::class, 'index'])->name('user.dashboard')->middleware(['auth']);

// Profile routes
Route::middleware(['auth'])->group(function () {
    Route::get('user/profile', [App\Http\Controllers\User\ProfileController::class, 'show'])->name('profile.show');
    Route::put('user/profile', [App\Http\Controllers\User\ProfileController::class, 'updateProfile'])->name('profile.update');
    Route::put('user/profile/password', [App\Http\Controllers\User\ProfileController::class, 'updatePassword'])->name('profile.password.update');
    Route::put('user/profile/photo', [App\Http\Controllers\User\ProfileController::class, 'updatePhoto'])->name('profile.photo.update');
    Route::delete('user/profile/photo', [App\Http\Controllers\User\ProfileController::class, 'deletePhoto'])->name('profile.photo.delete');
});

// Notification routes
Route::middleware(['auth'])->group(function () {
    Route::get('user/notifications', [App\Http\Controllers\User\NotificationController::class, 'index'])->name('notifications.index');
    Route::post('user/notifications/{id}/read', [App\Http\Controllers\User\NotificationController::class, 'markAsRead'])->name('notifications.read');
    Route::post('user/notifications/read-all', [App\Http\Controllers\User\NotificationController::class, 'markAllAsRead'])->name('notifications.read-all');
    Route::delete('user/notifications/{id}', [App\Http\Controllers\User\NotificationController::class, 'destroy'])->name('notifications.destroy');
});

// Celebrity browsing routes
Route::get('celebrities', [HomePageController::class, 'book'])->name('celebrities.index');
Route::get('celebrities/{id}', [HomePageController::class, 'book'])->name('celebrities.show');

// Modern Booking management routes
Route::get('booking/history', [App\Http\Controllers\BookingController::class, 'index'])->name('booking.history')->middleware(['auth']);
Route::get('booking/{reference}', [App\Http\Controllers\BookingController::class, 'show'])->name('booking.show');
Route::get('booking/{reference}/edit', [App\Http\Controllers\BookingController::class, 'edit'])->name('booking.edit');
Route::put('booking/{reference}', [App\Http\Controllers\BookingController::class, 'update'])->name('booking.update');
Route::post('booking/{reference}/cancel', [App\Http\Controllers\BookingController::class, 'cancelBooking'])->name('booking.cancel');
Route::post('booking/guest/find', [App\Http\Controllers\BookingController::class, 'findGuestBooking'])->name('booking.guest.find');
Route::get('celebrity/check-availability/{id}', [App\Http\Controllers\BookingController::class, 'checkAvailability'])->name('booking.checkAvailability');
Route::post('donate_store', [HomePageController::class, 'donate_store'])->name('donate_store');
Route::post('apply_membership_card', [HomePageController::class, 'apply_membership_card'])->name('apply_membership_card');
Route::post('loan_application', [HomePageController::class, 'loan_application'])->name('loan_application');

Route::get('terms', [HomePageController::class, 'terms'] )->name('terms');
Route::get('privacy',[HomePageController::class, 'privacy'])->name('privacy');
Route::post('sendcontact', 'App\Http\Controllers\User\UsersController@sendcontact')->name('enquiry');

// Contact routes
Route::get('contact', [App\Http\Controllers\ContactController::class, 'index'])->name('contact');
Route::post('contact/send', [App\Http\Controllers\ContactController::class, 'send'])->name('contact.send');

// Newsletter routes
Route::post('newsletter/subscribe', [App\Http\Controllers\NewsletterController::class, 'subscribe'])->name('newsletter.subscribe');
Route::post('newsletter/unsubscribe', [App\Http\Controllers\NewsletterController::class, 'unsubscribe'])->name('newsletter.unsubscribe');
